<?php
	global $wp_query;
    $content_array = $wp_query->get_queried_object();
	if(isset($content_array->ID)){
    	$post_id = $content_array->ID;
	}	
	else $post_id=0;

	$template_uri = get_template_directory_uri();
	$SEO_description = get_bloginfo('description');

	if (isset($post_id)){
		$pagecustoms = getOptions($post_id);
		//Background Custom
		if(isset($pagecustoms["alterego_background_active"])){
			$def_background = wp_get_attachment_image_src($pagecustoms["alterego_background_src"],'full');
			$def_background = $def_background[0]; 
			$def_background_style = $pagecustoms["alterego_background_type"];
		}
	}


	$SEO_tags="";
	
	if ( function_exists( 'get_option_tree') ) {
		$logo_subline = get_option_tree( 'alterego_logo_tagline' );
		$alterego_favicon = get_option_tree( 'alterego_favicon' );
		if(get_option_tree( 'alterego_search_box' )) $alterego_search_box="on"; else $alterego_search_box="off";
		if(get_option_tree( 'alterego_top_panel_active' )) $alterego_top_panel_active="on"; else $alterego_top_panel_active="off";
		if(get_option_tree('alterego_seo_active')){
			$SEO_description .= " ".strip_tags(get_option_tree('alterego_seo_global_description')); 
			$SEO_tags = get_option_tree('alterego_seo_global_tags'); 

				if(get_option_tree('alterego_seo_page_active')){
					
					$SEO_description .= " ".strip_tags(my_get_the_excerpt($post_id));
					
					$posttags = get_the_tags();
					if ($posttags) {
					  foreach($posttags as $tag) {
					  	if($SEO_tags!="") $SEO_tags .= ', ';
					    $SEO_tags .= $tag->name ; 
					  }
					}
				}
		}
		// Background Default
			$def_background = get_option_tree( 'alterego_body_background_image' );
			$def_background_style = get_option_tree( 'alterego_background_image_style' );
			$def_background_tile = get_option_tree( 'alterego_body_background_tile' );
	}

		if (isset($post_id)){
			$pagecustoms = getOptions($post_id);
			//Background Custom
			if(isset($pagecustoms["alterego_background_active"])){
				$def_background = wp_get_attachment_image_src($pagecustoms["alterego_background_src"],'full');
				$def_background = $def_background[0]; 
				$def_background_style = $pagecustoms["alterego_background_type"];
				if(isset($pagecustoms["alterego_background_tile_src"])){
					$def_background_tile = wp_get_attachment_image_src($pagecustoms["alterego_background_tile_src"],'full');
					$def_background_tile = $def_background_tile[0]; 
				}
				else $def_background_tile = "";
			}
		}
		
		$alterego_search = __('Search the Site...', 'alterego');

?>
<!DOCTYPE html>

<!--
#######################################
	- THE HEAD PART -
######################################
-->

<html><!-- <html <?php language_attributes(); ?> -->
<head>

	<!-- Basic Page Needs
  ================================================== -->
	<meta charset="utf-8">
	<title><?php echo wp_title(" | ",1,'right'); ?><?php echo get_bloginfo('name'); ?> </title>
	
	<!--[if lt IE 9]>
		<script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script>
	<![endif]-->

	<meta http-equiv="Content-Type" content="<?php echo get_bloginfo('html_type'); ?>; charset=<?php echo get_bloginfo('charset'); ?>" />
	<meta name="keywords" content="<?php echo $SEO_tags; ?>" />
	<meta name="description" content="<?php echo $SEO_description; ?>" />
	<meta name="robots" content="index, follow" />
	<meta name="SKYPE_TOOLBAR" content="SKYPE_TOOLBAR_PARSER_COMPATIBLE" />
	<meta http-equiv="X-UA-Compatible" content="IE=edge" />

	
	<?php
			if(strpos($alterego_favicon, "ttp:")) $alterego_favicon = $alterego_favicon;
			else $alterego_favicon = get_template_directory_uri().'/images/'.$alterego_favicon;
	?>          
    <link rel="shortcut icon" href="<?php echo $alterego_favicon;?>" type="image/png">     
	<link href='http://fonts.googleapis.com/css?family=PT+Sans+Narrow' rel='stylesheet' type='text/css'>
	
     <?php wp_head(); ?> 
</head>



<!--
#######################################
	- THE BODY PART -
######################################
-->
<body>
<!--body  <?php body_class( ); ?>-->


			
	<!-- 
	###########################
		-  BACK TO TOP -
	###########################
	-->	
	<div id="backtotop"><div class="bttbg"></div></div>
	<!--
		##################################
			-	BACKGROUND MODULE	-
		##################################
		
			- bg-fit-outside or
			- bg-fit-inside or
			- bg-stretch
			- bg-tiled
			
			and 
			
			- fadein
		###################################
		-->
		
				
		<div id="main-background">
			<?php
			if(strpos($def_background, "ttp:")) $def_background = $def_background;
			else $def_background = get_template_directory_uri().'/'.$def_background;
			if($def_background_tile!=""){
				if(strpos($def_background_tile, "ttp:")) $def_background_tile = $def_background_tile;
				else $def_background_tile = get_template_directory_uri().'/'.$def_background_tile;
			}
			?>												
			<div class="bg-<?php echo $def_background_style;?> bg-fadein" data-category="a" data-src="<?php echo $def_background;?>"></div>						
			<div class="fullbgcover" style="background:url(<?php echo $def_background_tile; ?>) repeat;"></div>
		</div>				
		
		<script>
		   //BACKGROUND STARTER			
			jQuery("#main-background").tpbackground({
						slideshow:0,
						callback:"false",
						cat:""						
					});	
		</script>
	
	<!--
		##################################
			-	THE CONTAINER	-
		##################################
		-->
		<div class="container" id="content_container">
		
							
				<div id="content">			
							
							
							<div class="" id="header">
										
										
										
										<!--
										########################################################################
											-	SITE LOGO // TOPLINE // PHONE NUMBER // SEARCH FIELD	-
										########################################################################
										-->
										<div class="sitelogo"><a href="<?php echo home_url(); ?>"><div style="width:100%;height:100%;position:absolute;top:0px;left:0px;"></div></a></div>
										
									
									
										<div class="headright_holder">	
											<div class="fh-phone headerinfo"><?php echo get_option_tree("alterego_headerinfo");?></div>
											
											<div id="search" style="float:right">
												<form method="get" action="<?php echo home_url(); ?>/">
													<input type="text" id="Form_Search" name="s" value="<?php echo $alterego_search;?>" class="InputBox" />
													<input type="submit" id="Form_Go" value="" class="Button" />
												</form>
											</div>
											<div class="clear"></div>
										</div>
										<div class="clear"></div>						
										
									
									<!--
									#########################################
										-	MENU NAVIGATION	-
									#########################################
									-->
										<div class="divide40"></div>
										<div class="pagedivider" ></div>
										<div id="navholder"><?php wp_nav_menu( array( 
													'menu' 			=> '',
													'container'       => 'div', 
													'container_class' => 'left',
													'container_id' 	=> 'nav',
													'before' => '',
													'after' => '',
													'link_before' => '',
													'link_after' => '',
													'depth' => 0,
													'walker' => new description_walker()
											)); ?></div>
									<div class="clear"></div>
									<div class="nav_shadow"></div>
									<script>
										subarrow_count=0;
										jQuery("#nav ul > li").each(function(){
											$this = jQuery(this);
											if($this.find(".arrow_menu").length){
												if(!$this.find("ul").length) $this.find(".arrow_menu,.menudivider").remove();
												subarrow_count++;
											}
										});
										jQuery(document).ready(function(){
											if(!subarrow_count) jQuery(".entering_holder").css("padding-top","80px");
										});
									</script>
												 
							</div>

					</div>														
							
							<div class="clear"></div>
							<div class="divide50"></div>

		